###### Produtos Madeireiros ###########

# Atencao: Este script foi salvo criado com codificacao UTF-8.

# Essa função tem apenas o argumentos "grupo". 
# grupo = (geral, grupo1, grupo2, grupo3)

# Pacotes usados
library(data.table)
library(dplyr)
library(tidyr)
library(ggplot2)
library(scales)
library(forcats) #para a função fct_reorder()
library(grid)
library(gridExtra)

# Lê sisdof_produto
sisdof_produto <- fread("SisDOF_Destino_2012_2017.csv",
                        colClasses = c("character", "character", "character",
                                       "character", "character", "character",
                                       "character", "character", "character",
                                       "character", "character", "character",
                                       "character", "character", "character",
                                       "character", "numeric", "numeric"))

# Deleta coluna V1 criada pelo comando fread.
sisdof_produto$V1 <- NULL

#### Formatacao dos nomes dos produtos ####

# Funcao para passar a primeira letra para maiuscula
capFirst <- function(s) {
    paste(toupper(substring(s, 1, 1)), substring(s, 2), sep = "")
}

# Passa primeira letra para maiuscula
sisdof_produto$Produto <- capFirst(sisdof_produto$Produto)

# Troca "." por espaços
#sisdof_produto1 <- sisdof_produto[1:10000]
#unique(sisdof_produto1$Produto)
sisdof_produto$Produto <- gsub("\\.+", " ", sisdof_produto$Produto)

# Faz correcao ortografica manualmente
unique(sisdof_produto$Produto)

sisdof_produto$Produto[sisdof_produto$Produto == "Mouroes"] <- "Mourões"
sisdof_produto$Produto[sisdof_produto$Produto == "Palanques rolicos"] <- "Palanques roliços"
sisdof_produto$Produto[sisdof_produto$Produto == "Produto Nao Madeireiro"] <- "Produto Não Madeireiro"
sisdof_produto$Produto[sisdof_produto$Produto == "Madeira serrada (tabua)"] <- "Madeira serrada (tábua)"
sisdof_produto$Produto[sisdof_produto$Produto == "Residuo para aproveitamento industrial"] <- "Resíduo para aproveitamento industrial"
sisdof_produto$Produto[sisdof_produto$Produto == "Madeira serrada (pranchao desdobrado)"] <- "Madeira serrada (pranchão desdobrado)"
sisdof_produto$Produto[sisdof_produto$Produto == "Bloco, quadrado ou file"] <- "Bloco, quadrado ou filé"
sisdof_produto$Produto[sisdof_produto$Produto == "Residuo para fins energeticos"] <- "Resíduo para fins energéticos"
sisdof_produto$Produto[sisdof_produto$Produto == "Lamina desenrolada"] <- "Lâmina desenrolada"
sisdof_produto$Produto[sisdof_produto$Produto == "Lamina faqueada"] <- "Lâmina faqueada"
sisdof_produto$Produto[sisdof_produto$Produto == "Rodape"] <- "Rodapé"
sisdof_produto$Produto[sisdof_produto$Produto == "Tabua curta"] <- "Tábua curta"
sisdof_produto$Produto[sisdof_produto$Produto == "Porta lisa macica"] <- "Porta lisa maciça"
sisdof_produto$Produto[sisdof_produto$Produto == "Residuo de lamina"] <- "Resíduo de lâmina"


#### Funcao para gerar graficos ####
    produto <- function (grupo) {
 
    # grupo = (geral, grupo1, grupo2, grupo3)
    
    # geral = todas as espécies 
    # grupo1 = especies de grande movimentacao
    # grupo2 = ameacadas (Portaria 443)
    # grupo3 = cites
    
    ifelse(!dir.exists(file.path("Figuras", 
                                 "1.2.Produto.Acabado", 
                                 "1.2.7.Produto")),
           dir.create(file.path("Figuras", 
                                "1.2.Produto.Acabado", 
                                "1.2.7.Produto"),
                      recursive = TRUE),
           FALSE)
    
    setwd(file.path("Figuras", 
                    "1.2.Produto.Acabado", 
                    "1.2.7.Produto"))
    
    # Função para passar apenas a primeira letra de uma palavra para maiúscula
    capFirst <- function(s) {
        paste(toupper(substring(s, 1, 1)), substring(s, 2), sep = "")
    }
    
    # Títulos do gráfico
    titulo.grupo <- capFirst(grupo)
    g.titulo <- "Tipos de Produtos Madeireiros Consumidos"   # Primeiro titulo do grafico
    g.sub.titulo <- "Volume relativo movimentado de 2012 a 2017 (%)"
    
    # Cores do Grafico: Tons vermelhos 
    cor_segmento <- "salmon"                # cor da linha   
    cor_ponto <- "firebrick4"                   # cor do ponto
    
    # Dimensoes do grafico
    #largura <- 10.3
    texto <- 21.87
    bola <- 25.5
    
    if ( grupo == "geral") {
        
        y <- sisdof_produto
        g.sub.titulo.grupo <- "Todas as espécies"
        
    } else if (grupo == "grupo1") {
        
        lista_especies <- unique(sisdof_produto[sisdof_produto$Grupo == "Grupo.1"]$Especie)   # lista os nomes das espécies contidas no grupo 1
        y <- sisdof_produto[sisdof_produto$Grupo == "Grupo.1"]                            # subset com as espécies do grupo 1
        g.sub.titulo.grupo <- "25 Espécies mais movimentadas"
        
    } else if (grupo == "grupo2") {
        
        lista_especies <- unique(sisdof_produto[sisdof_produto$Grupo == "Grupo.2"]$Especie)   # lista os nomes das espécies contidas no grupo 2
        y <- sisdof_produto[!is.na(sisdof_produto$Portaria.443)]                        # subset com as espécies da portaria 443 e que nao estao nos grupos 1 ou 3
        g.sub.titulo.grupo <- "Espécies ameaçadas de extinção"
                         
    } else if (grupo == "grupo3") {
        
        lista_especies <- unique(sisdof_produto[sisdof_produto$Grupo == "Grupo.3"]$Especie)   # lista os nomes das espécies contidas no grupo 3
        y <- sisdof_produto[!is.na(sisdof_produto$Cites)]                                # subset com as espécies da portaria 443 e que nao estao nos grupos 1 ou 3
        g.sub.titulo.grupo <- "Espécies CITES"
                         
    }
    
    ## Faz o gráfico dos grupos
    
    # Agrega de acordo com o produto
    agregado <- y[, .(sum(Volume.Total)),
                  by = .(y$Produto)]
    
    # Cria a coluna volume percentual
    agregado$Volume.Percentual <- agregado$V1/sum(agregado$V1)*100
    
    # Renomeia as colunas V1 e V2  
    colnames(agregado) <- c("Produto", "Volume.Total", "Volume.Percentual")
    
    # Para o grafico entender que é pra ordenar pelo Volume.Total
    agregado$Produto <- factor(agregado$Produto, 
                                  levels = unique(agregado$Produto)[order(agregado$Volume.Percentual, 
                                                                             decreasing = TRUE)])
   
    # Ordena de forma crescente em relação ao Volume.Total
    agregado <- agregado[order(agregado$Volume.Percentual, decreasing = TRUE),]
    
    # Seleciona no máximo 10 produtos
    
    if (length(unique(agregado$Produto)) >= 10) {
        
        agregado <- agregado[1:10,]
        
        }   else {
        
        agregado <- agregado[1:length(unique(agregado$Produto)),]
        
        }   
    
    # Largura do grafico. Varia de acordo com o tamanho do titulo ou subtitulo. Como a fonte do titulo e 10% maior do que a do subtitulo, multiplicamos por 1.11.
    
    largura <- data.table(tipo = c("g.titulo", "lista.especie", "g.sub.titulo"),
                          valor = c(nchar(g.titulo), 
                                    nchar(g.sub.titulo.grupo),
                                    nchar(g.sub.titulo),
                                    1.2*max(nchar(as.character(agregado$Produto)), na.rm = TRUE)))
    
    largura <- max(largura$valor, na.rm = TRUE)
    
    # Altura do grafico
    altura <- 1.6 + (0.8*length(agregado$Produto))
    
    if (length(agregado$Produto) != 0) {
        
        # Para ordenar as barras de forma decrescente quando o grafico fica deitado.
        agregado <- mutate(agregado,  Produto = fct_reorder(agregado$Produto,
                                                                 agregado$Volume.Percentual))
        
        
    # Gera o grafico percentual
    gplot <- ggplot(agregado, aes(agregado$Produto, 
                                agregado$Volume.Percentual)) +
        geom_segment(aes(x = agregado$Produto, 
                         y = 0, 
                         xend = agregado$Produto, 
                         yend = agregado$Volume.Percentual),
                     position = position_dodge(width = 0.8),
                     color = cor_segmento,
                     size = bola/3) +
        geom_point(size = bola,
                   color = cor_ponto,
                   position = position_dodge(width = 0.8))+
        scale_y_continuous(limits=c(0, 1.1*max(agregado$Volume.Percentual)), oob=rescale_none)+
        geom_text(aes(label = format(round(Volume.Percentual, 2),     # texto do Volume.Percentual
                                     big.mark = ".", 
                                     decimal.mark = ",")),
                  color = "white", 
                  size = 0.3*texto,
                  fontface = "bold")+
        theme(plot.title = element_text(lineheight = 0.1, 
                                        face = "bold",
                                        hjust = 0.5,
                                        size = 1.3*texto),
              plot.subtitle = element_text(lineheight = 0.4, 
                                           face = "bold",
                                           hjust = 0.5,
                                           size = 1.17*texto),
              axis.title.y = element_blank(),
              axis.text.y = element_text(size = 1.1*texto,
                                         color = cor_ponto,
                                         face = "bold",
                                         hjust = 0),
              axis.title.x = element_blank(),
              axis.text.x = element_blank(),
              axis.ticks.x = element_blank(),
              axis.ticks.y = element_blank(),
              panel.background = element_blank(),
              panel.grid.major = element_blank(), 
              panel.grid.minor = element_blank())+
        coord_flip()
    
    # Abre para gravacao em PDF
    pdf(paste0("#", 
               titulo.grupo, 
               "_Produtos.pdf"), 
        width = largura/3.15, 
        height = altura)
    
    grid.arrange(
        gplot,
        nrow = 1,
        top = textGrob(paste0(g.titulo,
                              "\n",
                              g.sub.titulo.grupo,
                              "\n",
                              g.sub.titulo),
                       gp = gpar(fontface = 2, 
                                 fontsize = 26,
                                 lineheight = 0.8)))
    
    # Fecha o PDF
    dev.off()
    
    }
    
   ## Faz os gráficos para cada uma das espécies da lista dos grupos 1, 2 ou 3.
    
    if (grupo == "grupo1" | grupo == "grupo2" | grupo == "grupo3") {
        
        for (i in 1:length(lista_especies)) {
            especie <- y[y$Especie == lista_especies[i]]
            
            # Agrega de acordo com os tipos de produtos
            especie <- especie[, .(sum(Volume.Total)),
                               by = .(especie$Produto)]
            
            colnames(especie) <- c("Produto", "Volume.Total")
            
            # Cria a coluna volume percentual
            especie$Volume.Percentual <- especie$Volume.Total/sum(especie$Volume.Total)*100
            
            # Para o grafico entender que é pra ordenar pelo Volume.Total
            especie$Produto <- factor(especie$Produto, 
                                              levels = unique(especie$Produto)[order(especie$Volume.Percentual, 
                                                                                             decreasing = TRUE)])
                                                                                         
            
            # Ordena de forma crescente em relação ao Volume.Total
            especie <- especie[order(especie$Volume.Percentual, decreasing = TRUE),]
            
            # Seleciona no máximo 20 paises
            
            if (length(unique(especie$Produto)) >= 10) {
                
                especie <- especie[1:10,]
                
                }   else {
                
                especie <- especie[1:length(unique(especie$Produto)),]
                
                }   
            
            # Largura do grafico.
            largura <- data.table(tipo = c("g.titulo", "lista.especie", "g.sub.titulo"),
                                  valor = c(nchar(g.titulo), 
                                            nchar(lista_especies[i]),
                                            nchar(g.sub.titulo),
                                            1.2*max(nchar(as.character(especie$Produto)), na.rm = TRUE)))
            
            largura <- max(largura$valor, na.rm = TRUE)
            
            # Altura do grafico
            altura <- 1.6 + (0.8*length(especie$Produto))
            
            if (length(especie$Produto) != 0) {
                
                # Para ordenar as barras de forma decrescente quando o grafico fica deitado.
                especie <- mutate(especie,  Produto = fct_reorder(especie$Produto,
                                                                       especie$Volume.Percentual))
            
            gplot <- ggplot(especie, 
                            aes(especie$Produto,
                                especie$Volume.Percentual))+
                geom_segment(aes(x = especie$Produto, 
                                 y = 0, 
                                 xend = especie$Produto, 
                                 yend = especie$Volume.Percentual),
                             position = position_dodge(width = 0.8),
                             color = cor_segmento,
                             size = bola/3) +
                geom_point(size = bola,
                           color = cor_ponto,
                           position = position_dodge(width = 0.8))+
                scale_y_continuous(limits=c(0, 1.1*max(especie$Volume.Percentual)), oob=rescale_none)+
                geom_text(aes(label = format(round(Volume.Percentual, 2),     # texto do Volume.Percentual
                                             big.mark = ".", 
                                             decimal.mark = ",")),
                          color = "white", 
                          size = 0.3*texto,
                          fontface = "bold")+
                theme(plot.title = element_text(lineheight = 0.1, 
                                                face = "bold",
                                                hjust = 0.5,
                                                size = 1.3*texto),
                      plot.subtitle = element_text(lineheight = 0.4, 
                                                   face = "bold",
                                                   hjust = 0.5,
                                                   size = 1.17*texto),
                      axis.title.y = element_blank(),
                      axis.text.y = element_text(size = 1.1*texto,
                                                color = cor_ponto,
                                                face = "bold",
                                                hjust = 0),
                      axis.title.x = element_blank(),
                      axis.text.x = element_blank(),
                      axis.ticks.x = element_blank(),
                      axis.ticks.y = element_blank(),
                      panel.background = element_blank(),
                      panel.grid.major = element_blank(), 
                      panel.grid.minor = element_blank())+
                coord_flip()
            
            
            # Abre para gravacao em PDF
            pdf(paste0(titulo.grupo,"_", 
                       lista_especies[i],
                       "_Produto.pdf"), 
                width = largura/3.15, 
                height = altura)
            
            grid.arrange(
                gplot,
                nrow = 1,
                top = textGrob(paste0(g.titulo,
                                      "\n",
                                      lista_especies[i],
                                      "\n",
                                      g.sub.titulo),
                               gp = gpar(fontface = 2, 
                                         fontsize = 26,
                                         lineheight = 0.8)))
            
            # Fecha o PDF
            dev.off()
            
            }
        }
        
    }
    
    setwd("..")
    setwd("..")
    setwd("..")
    
}    

produto("geral")
produto("grupo1")
produto("grupo2")
produto("grupo3")









